<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contador de Pedidos</title>
    <link id="u-page-google-font" rel="stylesheet" href="https://fonts.googleapis.com/css?family=Montserrat:700|Poppins:400">
    <style>
        body {
            font-family: 'Poppins', Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background: url('fondocem.png') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
            text-align: center;
        }
        h1 {
            font-family: 'Poppins', sans-serif;
            font-size: 48px;
            margin: 0;
        }
        .contador {
            font-family: 'Montserrat', sans-serif;
            font-size: 96px;
            font-weight: 700;
            margin: 20px 0;
        }
        h2 {
            font-family: 'Poppins', sans-serif;
            font-size: 48px;
            margin: 0;
        }
        .detalle-confirmados {
            font-family: 'Poppins', sans-serif;
            font-size: 22px;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div>
        <h1>LLEVAMOS</h1>
        <div class="contador" id="contador">
            <?php
                // Leer el número de posibles pedidos desde contador_pedidos.txt
                $archivoContador = 'contador_pedidos.txt';
                $posiblesPedidos = file_exists($archivoContador) ? file_get_contents($archivoContador) : '0';
                echo htmlspecialchars(trim($posiblesPedidos));
            ?>
        </div>
        <h2>POSIBLES PEDIDOS</h2>
        <div class="detalle-confirmados">
            <?php
                // Leer el número de pedidos confirmados desde pedidos_confirmados.txt
                $archivoConfirmados = 'contador_pedidos_confirmados.txt';
                $pedidosConfirmados = file_exists($archivoConfirmados) ? file_get_contents($archivoConfirmados) : '0';
                echo "Confirmados: " . htmlspecialchars(trim($pedidosConfirmados)) . " inscritos";

                // Obtener la última fecha de modificación del archivo pedidos_confirmados.txt
                if (file_exists($archivoConfirmados)) {
                    $fechaModificacion = date("d/m/y H:i", filemtime($archivoConfirmados));
                    echo "<br>Última revisión: " . $fechaModificacion;
                }
            ?>
        </div>
    </div>
</body>
</html>
