<?php
// ===============================
//  Helpers: escritura de registros
// ===============================
function escribirCSV($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code) {
    $archivo = 'registros.csv';
    $fechaRegistro = date('Y-m-d H:i:s');

    // Dirección viene ya unificada (Dirección + Comuna)
    $datos = array(
        $fechaRegistro,
        $name,
        $lastname,
        $rut,
        "+56 9 $phone",
        $email,
        $birthdate,
        $address,
        $region,
        $subscription,
        $discount_code
    );

    $manejador = fopen($archivo, 'a');
    if ($manejador) {
        fputcsv($manejador, $datos);
        fclose($manejador);
    }
}

function escribirTXT($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code) {
    $archivo = 'registros.txt';
    $fechaRegistro = date('Y-m-d H:i:s');

    $contenido  = "Registro realizado el: $fechaRegistro\n";
    $contenido .= "Nombre(s): $name\n";
    $contenido .= "Apellidos: $lastname\n";
    $contenido .= "RUT: $rut\n";
    $contenido .= "Teléfono: +56 9 $phone\n";
    $contenido .= "Correo Electrónico: $email\n";
    $contenido .= "Fecha de nacimiento: $birthdate\n";
    $contenido .= "Dirección: $address\n";
    $contenido .= "Región: $region\n";
    $contenido .= "Plan Online Gamma $subscription\n";
    $contenido .= "Código de descuento utilizado: $discount_code\n";
    $contenido .= "--------------------------\n";

    file_put_contents($archivo, $contenido, FILE_APPEND);
}

// ===============================
//  Validación de códigos
// ===============================
function verificarCodigoDescuento($codigo) {
    $archivo = 'codigos_descuento.txt';
    if (!file_exists($archivo)) return false;

    $codigosValidos = file($archivo, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    // Normaliza lista a MAYÚSCULAS + sin espacios
    $codigosValidos = array_map(function($c){
        return strtoupper(trim($c));
    }, $codigosValidos);

    return in_array(strtoupper(trim($codigo)), $codigosValidos, true);
}

// ===============================
//  Email
// ===============================
function enviarCorreo($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code) {
    $correo_remitente = "admision@mauroquintana.cl";
    $nombre_remitente = "CEM Mauro Quintana";
    $destinatario     = "admision@mauroquintana.cl";
    $asunto           = "Nueva venta Gamma $subscription";

    $mensaje  = "Se ha recibido un nuevo pedido:\n\n";
    $mensaje .= "Nombre(s): $name\n";
    $mensaje .= "Apellidos: $lastname\n";
    $mensaje .= "RUT: $rut\n";
    $mensaje .= "Teléfono: +56 9 $phone\n";
    $mensaje .= "Correo Electrónico: $email\n";
    $mensaje .= "Fecha de nacimiento: $birthdate\n";
    $mensaje .= "Dirección: $address\n";
    $mensaje .= "Región: $region\n";
    $mensaje .= "Plan Online Gamma $subscription\n";
    $mensaje .= "Código de descuento utilizado: $discount_code\n";

    $headers  = "From: " . $nombre_remitente . " <" . $correo_remitente . ">\r\n";
    $headers .= "Reply-To: " . $correo_remitente . "\r\n";
    $headers .= "Content-Type: text/plain; charset=utf-8\r\n";
    $headers .= "MIME-Version: 1.0\r\n";

    if (!mail($destinatario, $asunto, $mensaje, $headers)) {
        echo json_encode([
            'error' => 'Hubo un error al enviar el correo.'
        ]);
        exit();
    }
}

// ===============================
//  MAIN
// ===============================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Sanitiza inputs
    $name         = htmlspecialchars($_POST['name'] ?? '');
    $lastname     = htmlspecialchars($_POST['lastname'] ?? '');
    $rut          = htmlspecialchars($_POST['rut'] ?? '');
    $phone        = htmlspecialchars($_POST['phone'] ?? '');
    $email        = htmlspecialchars($_POST['email'] ?? '');
    $birthdate    = htmlspecialchars($_POST['birthdate'] ?? '');

    // NUEVO: Dirección y Comuna por separado en el form
    $address_line = htmlspecialchars($_POST['address_line'] ?? '');
    $comuna       = htmlspecialchars($_POST['comuna'] ?? '');

    $region       = htmlspecialchars($_POST['region'] ?? '');
    $subscription = htmlspecialchars($_POST['subscription'] ?? '');
    $has_discount = htmlspecialchars($_POST['has_discount'] ?? '');

    // ---------------------------
    // Unificar Dirección + Comuna
    // (Se guardan y envían como un SOLO dato "Dirección")
    // ---------------------------
    $address_line_clean = trim(preg_replace('/\s+/', ' ', $address_line));
    $comuna_clean       = trim(preg_replace('/\s+/', ' ', $comuna));
    $address_full       = $address_line_clean . ' — Comuna: ' . $comuna_clean;

    // ---------------------------
    // Validación del código
    // ---------------------------
    $discount_code = '';
    if ($has_discount === 'si') {
        // Normaliza (TRIM + MAYÚSCULAS)
        $discount_code = strtoupper(trim(htmlspecialchars($_POST['discount_code'] ?? '')));

        if (empty($discount_code) || !verificarCodigoDescuento($discount_code)) {
            echo json_encode([
                'error' => 'El código de descuento ingresado no es válido o está vacío.'
            ]);
            exit();
        }
    }

    // ---------------------------
    // Validación de campos requeridos
    // ---------------------------
    if (
        empty($name) || empty($lastname) || empty($rut) || empty($phone) ||
        empty($email) || empty($birthdate) || empty($address_line) || empty($comuna) ||
        empty($region) || empty($subscription)
    ) {
        echo json_encode([
            'error' => 'Por favor, completa todos los campos requeridos.'
        ]);
        exit();
    }

    // ---------------------------
    // Guardar registros
    // ---------------------------
    escribirCSV($name, $lastname, $rut, $phone, $email, $birthdate, $address_full, $region, $subscription, $discount_code);
    escribirTXT($name, $lastname, $rut, $phone, $email, $birthdate, $address_full, $region, $subscription, $discount_code);

    // ---------------------------
    // Enviar correo
    // ---------------------------
    enviarCorreo($name, $lastname, $rut, $phone, $email, $birthdate, $address_full, $region, $subscription, $discount_code);

    // ---------------------------
    // Redirect URL
    // Reglas especiales:
    // - MAURO → URL fija (prioridad máxima)
    // - JANO  → se comporta como sin código (sin /Cod/)
    // ---------------------------
    $discount_code_upper = strtoupper(trim($discount_code));

    if ($has_discount === 'si' && $discount_code_upper === 'MAURO') {

        $redirect = 'https://pagos.mauroquintana.cl/Gamma/Anual/';

    } else {

        // Regla: si el código es JANO, redirige como si NO tuviera código (sin /Cod/)
        $usarCodLink = ($has_discount === 'si' && $discount_code_upper !== 'JANO');

        $redirect = ($subscription === 'semestral')
            ? ($usarCodLink ? 'https://pagos.mauroquintana.cl/Gamma/Anual/Cod/' : 'https://pagos.mauroquintana.cl/Gamma/Anual/')
            : ($usarCodLink ? 'https://pagos.mauroquintana.cl/Gamma/Anual/Cod/' : 'https://pagos.mauroquintana.cl/Gamma/Anual/');
    }

    echo json_encode([
        'redirect_url' => $redirect
    ]);
    exit();
}
?>
