<?php
header('Content-Type: application/json; charset=utf-8');

// ---------- Helpers de formato ----------
function format_phone_cl($phoneRaw) {
    // deja solo dígitos
    $d = preg_replace('/\D/', '', $phoneRaw);
    // quédate con los últimos 8 (por si viene con prefijo)
    $d = substr($d, -8);
    if (strlen($d) < 8) return $d; // lo devuelvo tal cual si falta
    return substr($d, 0, 4) . ' ' . substr($d, 4, 4); // #### ####
}

function format_rut_cl($rutRaw) {
    // deja solo números y K
    $r = strtoupper(preg_replace('/[^0-9Kk]/', '', $rutRaw));
    if (strlen($r) < 2) return $rutRaw; // no alcanzan cuerpo+DV

    $dv = substr($r, -1);
    $cuerpo = substr($r, 0, -1);

    // puntos de miles
    $cuerpoFmt = number_format((int)$cuerpo, 0, '', '.'); // 12345678 -> 12.345.678
    return $cuerpoFmt . '-' . $dv;
}

// (opcional) validador DV módulo 11
function rut_dv($numStr) {
    $suma = 0; $mul = 2;
    for ($i = strlen($numStr)-1; $i >= 0; $i--) {
        $suma += intval($numStr[$i]) * $mul;
        $mul = ($mul === 7) ? 2 : $mul + 1;
    }
    $res = 11 - ($suma % 11);
    if ($res === 11) return '0';
    if ($res === 10) return 'K';
    return strval($res);
}
function rut_valido($rutFormateado) {
    $l = strtoupper(preg_replace('/[^0-9K]/', '', $rutFormateado));
    if (strlen($l) < 2) return false;
    $dv = substr($l, -1);
    $cuerpo = substr($l, 0, -1);
    return rut_dv($cuerpo) === $dv;
}

// ---------- Persistencia ----------
function escribirCSV($name, $lastname, $rut_fmt, $phone_fmt, $email, $birthdate, $address, $region, $discount_code) {
    $archivo = 'registros.csv';
    $fechaRegistro = date('Y-m-d H:i:s');
    $datos = array($fechaRegistro, $name, $lastname, $rut_fmt, "+56 9 $phone_fmt", $email, $birthdate, $address, $region, $discount_code);
    $m = fopen($archivo, 'a');
    fputcsv($m, $datos);
    fclose($m);
}

function escribirTXT($name, $lastname, $rut_fmt, $phone_fmt, $email, $birthdate, $address, $region, $discount_code) {
    $archivo = 'registros.txt';
    $fechaRegistro = date('Y-m-d H:i:s');
    $contenido  = "Registro realizado el: $fechaRegistro\n";
    $contenido .= "Nombre(s): $name\n";
    $contenido .= "Apellidos: $lastname\n";
    $contenido .= "RUT: $rut_fmt\n";
    $contenido .= "Teléfono: +56 9 $phone_fmt\n";
    $contenido .= "Correo Electrónico: $email\n";
    $contenido .= "Dirección: $address\n";
    $contenido .= "Región: $region\n";
    $contenido .= "Plan Online M2 Jano\n";
    $contenido .= "Código de descuento utilizado: $discount_code\n";
    $contenido .= "--------------------------\n";
    file_put_contents($archivo, $contenido, FILE_APPEND);
}

// ---------- Códigos de descuento ----------
function verificarCodigoDescuento($codigo) {
    $archivo = 'codigos_descuento.txt';
    if (!file_exists($archivo)) return false;
    $codigosValidos = file($archivo, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return in_array($codigo, $codigosValidos);
}

// ---------- Email ----------
function enviarCorreo($name, $lastname, $rut_fmt, $phone_fmt, $email, $birthdate, $address, $region, $discount_code) {
    $correo_remitente = "admision@mauroquintana.cl";
    $nombre_remitente = "CEM Mauro Quintana";
    $destinatario = "admision@mauroquintana.cl";
    $asunto = "Nueva venta JanoM2";

    $mensaje  = "Se ha recibido un nuevo pedido:\n\n";
    $mensaje .= "Nombre(s): $name\n";
    $mensaje .= "Apellidos: $lastname\n";
    $mensaje .= "RUT: $rut_fmt\n";
    $mensaje .= "Teléfono: +56 9 $phone_fmt\n";
    $mensaje .= "Correo Electrónico: $email\n";
    $mensaje .= "Fecha de nacimiento: $birthdate\n";
    $mensaje .= "Dirección: $address\n";
    $mensaje .= "Región: $region\n";
    $mensaje .= "Plan Online JanoM2\n";
    $mensaje .= "Código de descuento utilizado: $discount_code\n";

    $headers = "From: $nombre_remitente <$correo_remitente>\r\n";
    $headers .= "Reply-To: $correo_remitente\r\n";
    $headers .= "Content-Type: text/plain; charset=utf-8\r\n";
    $headers .= "MIME-Version: 1.0\r\n";

    if (!mail($destinatario, $asunto, $mensaje, $headers)) {
        echo json_encode(['error' => 'Hubo un error al enviar el correo.']);
        exit();
    }
}

// ---------- Handler ----------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitiza base
    $name       = htmlspecialchars($_POST['name'] ?? '');
    $lastname   = htmlspecialchars($_POST['lastname'] ?? '');
    $rut        = htmlspecialchars($_POST['rut'] ?? '');
    $phone      = htmlspecialchars($_POST['phone'] ?? '');
    $email      = htmlspecialchars($_POST['email'] ?? '');
    $birthdate  = htmlspecialchars($_POST['birthdate'] ?? '');
    $address    = htmlspecialchars($_POST['address'] ?? '');
    $region     = htmlspecialchars($_POST['region'] ?? '');
    $has_discount = htmlspecialchars($_POST['has_discount'] ?? 'no');
    $discount_code = '';

    if ($has_discount === 'si') {
        $discount_code = htmlspecialchars($_POST['discount_code'] ?? '');
        if ($discount_code === '' || !verificarCodigoDescuento($discount_code)) {
            echo json_encode(['error' => 'El código de descuento ingresado no es válido o está vacío.']);
            exit();
        }
    }

    // Valida requeridos
    if ($name==='' || $lastname==='' || $rut==='' || $phone==='' || $email==='' || $birthdate==='' || $address==='' || $region==='') {
        echo json_encode(['error' => 'Por favor, completa todos los campos requeridos.']);
        exit();
    }

    // ---- FORMATEA para mostrar/guardar ----
    $rut_fmt   = format_rut_cl($rut);                  // 12.345.678-9
    $phone_fmt = format_phone_cl($phone);              // 8765 4321

    // (opcional) valida DV; si quieres bloquear, descomenta:
    // if (!rut_valido($rut_fmt)) {
    //     echo json_encode(['error' => 'RUT inválido (DV no coincide).']);
    //     exit();
    // }

    // Persistencia
    escribirCSV($name, $lastname, $rut_fmt, $phone_fmt, $email, $birthdate, $address, $region, $discount_code);
    escribirTXT($name, $lastname, $rut_fmt, $phone_fmt, $email, $birthdate, $address, $region, $discount_code);

    // Email
    enviarCorreo($name, $lastname, $rut_fmt, $phone_fmt, $email, $birthdate, $address, $region, $discount_code);

    // Redirección según descuento
    echo json_encode([
        'redirect_url' => $has_discount === 'si'
            ? 'https://pagos.mauroquintana.cl/PlanM2/Cod/'
            : 'https://pagos.mauroquintana.cl/PlanM2/pago.html'
    ]);
    exit();
}
